import pandas as pd
import numpy as np

video_name = 'VID_084027'

models_first = ['m2', 'm3', 'm4', 'm8']
models_second = ['y5m', 'y5l', 'y5x']
models = models_first + models_second

data_version = 'aeresults'
energy_version = 'ene'

excel_path = './{}/{}_{}.xlsx'.format(data_version, video_name, energy_version)
df = pd.read_excel(excel_path)


data = []
for model in models:
    list2 = df[model].tolist()
    data.append(list2)

min_val = 0 # np.min(data)
max_val = np.max(data)
diff = max_val - min_val

model_sel = 3
model_data = data[model_sel]

num_bins = 10

bins = np.linspace(min_val, max_val, num_bins + 1)

hist, bin_edges = np.histogram(model_data, bins=bins, density=True)

cdf = np.cumsum(hist * np.diff(bin_edges))

pmf = []
for i in range(len(cdf)):
    if i == 0:
        pmf.append(cdf[i])
    else:
        pmf.append(cdf[i] - cdf[i-1])
print(pmf)

one_pmf_val = pmf[3]
print(one_pmf_val)

cdf_ranges = list(zip(bin_edges[:-1], bin_edges[1:], cdf, pmf))


print("CDF Points:")
for start, end, cdf_value, pmf_value in cdf_ranges:
    print(f"Accuracy Range: {start:.2f} to {end:.2f}, CDF: {cdf_value:.2f}, PMF: {pmf_value:.2f}")

